package com.iptv.iptvapp.data

import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.http.GET
import retrofit2.http.Query

interface IptvApiService {
    @GET("nepali/cc.php")
    suspend fun getChannels(
        @Query("login") login: String,
        @Query("uid") uid: String,
        @Query("serial") serial: String,
        @Query("pack_id") packId: Int
    ): ChannelResponse

    @GET("nepali/act.php")
    suspend fun checkActivation(
        @Query("login") login: String,
        @Query("uid") uid: String,
        @Query("serial") serial: String
    ): ChannelResponse

    companion object {
        private const val BASE_URL = "http://nepago.daaccess.com/"

        fun create(): IptvApiService {
            return Retrofit.Builder()
                .baseUrl(BASE_URL)
                .addConverterFactory(GsonConverterFactory.create())
                .build()
                .create(IptvApiService::class.java)
        }
    }
}
