package com.iptv.iptvapp.data

import android.content.Context
import androidx.datastore.preferences.core.edit
import androidx.datastore.preferences.core.stringPreferencesKey
import androidx.datastore.preferences.preferencesDataStore
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map

private val Context.dataStore by preferencesDataStore(name = "settings")

class SerialRepository(private val context: Context) {
    private val SERIAL_KEY = stringPreferencesKey("serial_number")

    val serialNumber: Flow<String?> = context.dataStore.data.map { preferences ->
        preferences[SERIAL_KEY]
    }

    suspend fun saveSerial(serial: String) {
        context.dataStore.edit { preferences ->
            preferences[SERIAL_KEY] = serial
        }
    }
}
